<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vault extends Model 
{

    protected $table = 'vaults';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function websites()
    {
        return $this->hasMany('App\Models\VaultWebsite', 'vault_id', 'id');
    }

    public function settings()
    {
        return $this->hasOne('App\Models\VaultSetting', 'vault_id', 'id');
    }

}